﻿import xbmcaddon
import xbmc
import sys
import urllib.request, urllib.error, urllib.parse
import threading
import os
import json
from bs4 import BeautifulSoup

ADDON = xbmcaddon.Addon( id = 'script.torrent-tv.ru' )
ADDON_ICON	 = ADDON.getAddonInfo('icon')
ADDON_PATH = ADDON.getAddonInfo('path')
ADDON_ICON	 = ADDON.getAddonInfo('icon')
DATA_PATH = xbmc.translatePath( os.path.join( "special://profile/addon_data", 'script.torrent-tv.ru') )
ENGINE_NOXBIT = 0
ENGINE_AS = 1
ENGINE_PROXY = 2
VERSION = '1.5.3'
skin = ADDON.getSetting('skin')
SKIN_PATH = ADDON_PATH
print(skin)
if (skin != None) and (skin != "") and (skin != 'st.anger'):
    SKIN_PATH = DATA_PATH

class MyThread(threading.Thread):
    def __init__(self, func, params, back = True):
        threading.Thread.__init__(self)
        self.func = func
        self.params = params
        #self.parent = parent

    def run(self):
        self.func(self.params)
    def stop(self):
        pass


def showMessage(message = '', heading='Torrent-TV.RU', times = 1234):
    try: 
        xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, %s)' % (heading.encode('utf-8'), message.encode('utf-8'), times, ADDON_ICON))
    except Exception as e:
        try: xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, %s)' % (heading, message, times, ADDON_ICON))
        except Exception as e:
            xbmc.log( 'showMessage: exec failed [%s]' % 3 )

def GET(target, post=None, cookie = None, tryies = 0):
    try:
        print(target)
        req = urllib.request.Request(url = target, data = post)
        req.add_header('User-Agent', 'XBMC (script.torrent-tv.ru)')
        if cookie:
            req.add_header('Cookie', 'PHPSESSID=%s' % cookie)
        resp = urllib.request.urlopen(req, timeout=10)
        http = resp.read()
        resp.close()
        return http
    except Exception as e:
        if tryies == 0:
            tryies = tryies + 1
            return GET(target, post, cookie, tryies)
        xbmc.log( 'GET EXCEPT [%s]' % (e), 4 )

def GET_JSON(target, post = None, cookie = None):
    return json.loads(GET(target, post, cookie))

def checkPort(params):
        data = GET("http://2ip.ru/check-port/?port=%s" % params)
        beautifulSoup = BeautifulSoup(data, 'html.parser')
        port = beautifulSoup.find('div', attrs={'class': 'ip-entry'}).find('span').get_text(strip=True).replace('\xa0', ' ')
       
        if port.find("Порт закрыт") > -1:
            return False
        else:
            return True

def getUserInfo(session):
    data = GET("http://api.ttv.run/v3/userinfo.php?session=%s&typeresult=json" % session)
    return json.loads(data)
    

def tryStringToInt(str_val):
    try:
        return int(str_val)
    except:
        return 0


def getSetting(name, default="", save=True):
    res = ADDON.getSetting(name)
    if res == "":
        res = default
        if res != "" and save:
            ADDON.setSetting(name, res)

    return res


def getSettingDef(name, name_cat):
    import xml.etree.ElementTree as ET
    import os
    path = os.path.join(ADDON_PATH, "resources/settings.xml")
    tree = ET.parse(path)
    xcat = [c for c in tree.getroot().findall("category") if c.attrib["label"] == name_cat][0]
    return [s for s in xcat.findall("setting") if s.attrib["id"] == name][0].attrib


def setSettingDef(name, name_cat, attrib, value):
    import xml.etree.ElementTree as ET
    import os
    path = os.path.join(ADDON_PATH, "resources/settings.xml")
    tree = ET.parse(path)
    xcat = [c for c in tree.getroot().findall("category") if c.attrib["label"] == name_cat][0]

    xel = [s for s in xcat.findall("setting") if s.attrib["id"] == name][0]
    xel.set(attrib, value)
    tree.write(path)


def setSetting(name, value):
    ADDON.setSetting(name, value)
